<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore;

use App\Entity\Order;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\BaseApiAwareAction;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Payum\Core\Reply\HttpResponse;
use Payum\Core\Request\GetHttpRequest;
use Payum\Core\Request\Notify;
use Sylius\Component\Core\Model\Payment;

/**
 * Class NotifyNullAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore
 */
class NotifyNullAction extends BaseApiAwareAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * @param Notify $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $this->gateway->execute($httpRequest = new GetHttpRequest());

        try {
            // get order model from requested order id
            $orderId = $httpRequest->request['orderID'];
            $order = $this->api->getOrderRepository()->find($orderId);
            if (null === $order) {
                throw new \Exception('Order not found');
            }

            $orderModel = $this->api->getPayum()->getStorage(get_class($order))->find($order);
            if (null === $orderModel) {
                throw new \Exception('Order Model not found');
            }
            // get payment model for order
            $payment = $orderModel->getPayments()[0];
            $paymentModel = $this->api->getPayum()->getStorage(get_class($payment))->find($payment);
            if (null === $paymentModel) {
                throw new \Exception('Payment not found');
            }
            // get the payment identity model for token usage
            $identityModel = $this->api->getPayum()->getStorage(get_class($paymentModel))->identify($paymentModel);
            // create a token with payment identity model
            $token = $this->api->getPayum()->getTokenFactory()->createNotifyToken('crefopay_hostedbefore', $identityModel);
        } catch (\Exception $exception) {
            $this->api->getApiFactory()->notificationProcessor()->log(
                $exception->getMessage(),
                'notificationRequest',
                $httpRequest->request
            );
            // throw empty http response here as we need to respond with status code 200 instead of 204 (payum notify default)
            throw new HttpResponse('');
        }

        $this->gateway->execute(new Notify($token));
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return
            $request instanceof Notify &&
            null === $request->getModel()
        ;
    }
}
