<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore;

use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\BaseApiAwareAction;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Payum\Core\Reply\HttpResponse;
use Payum\Core\Request\GetHttpRequest;
use Payum\Core\Request\Notify;

/**
 * Class NotifyAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore
 */
class NotifyAction extends BaseApiAwareAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * {@inheritDoc}
     *
     * @param Notify $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $this->gateway->execute($httpRequest = new GetHttpRequest());

        $notificationProcessor = $this->api->getApiFactory()->notificationProcessor();
        try {
            $this->api->getApiFactory()->notificationHandler($httpRequest->request, $notificationProcessor);
        } catch (\Exception $exception) {
            $notificationProcessor->setFailure(
                ArrayObject::ensureArrayObject($httpRequest->request),
                $exception->getMessage()
            );
        }

        $notificationProcessor->setTokenHash($request->getToken()->getHash());
        $notificationProcessor->run();

        // throw empty http response here as we need to respond with status code 200 instead of 204 (payum notify default)
        throw new HttpResponse('');
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return
            $request instanceof Notify &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
