<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore;

use Payum\Core\Action\ActionInterface;
use Payum\Core\Request\GetStatusInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Upg\Library\PaymentMethods\Methods;

/**
 * Class StatusAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore
 */
class StatusAction implements ActionInterface
{
    /**
     * {@inheritDoc}
     *
     * @param GetStatusInterface $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);

        $model = ArrayObject::ensureArrayObject($request->getModel());

        // default to "new"
        $request->markNew();

        $this->handleExternalPaymentResponseStatus($request);
        $this->handlePostProcessingPayments($request);
    }

    /**
     * @param GetStatusInterface $request
     */
    private function handleExternalPaymentResponseStatus($request)
    {
        $paymentTypes = [
            Methods::PAYMENT_METHOD_TYPE_PAYPAL,
            Methods::PAYMENT_METHOD_TYPE_SU,
        ];
        $model = ArrayObject::ensureArrayObject($request->getModel());
        if (in_array($model->get('paymentMethod', ''), $paymentTypes)
            && true === $model->get('externalPaymentSuccess', false)
        ) {
            $request->markAuthorized();
            if (true === $model->get('captured', false)
                && 'PAID' === $model->get('paymentStatus', 'PAYPENDING')
            ) {
                $request->markCaptured();
            }
        }
    }

    /**
     * @param GetStatusInterface $request
     */
    private function handlePostProcessingPayments($request)
    {
        $paymentTypes = [
            Methods::PAYMENT_METHOD_TYPE_CC3D,
            Methods::PAYMENT_METHOD_TYPE_CC,
            Methods::PAYMENT_METHOD_TYPE_PREPAID,
            Methods::PAYMENT_METHOD_TYPE_DD,
            Methods::PAYMENT_METHOD_TYPE_BILL_SECURE,
            Methods::PAYMENT_METHOD_TYPE_BILL,
            Methods::PAYMENT_METHOD_TYPE_COD,
            Methods::PAYMENT_METHOD_TYPE_IDEAL,
        ];

        $model = ArrayObject::ensureArrayObject($request->getModel());
        if (in_array($model->get('paymentMethod', ''), $paymentTypes)) {
            $request->markAuthorized();
            if (true === $model->get('captured', false)
                && 'PAID' === $model->get('paymentStatus', 'PAYPENDING')
            ) {
                $request->markCaptured();
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return
            $request instanceof GetStatusInterface &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
