<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay;

use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\CaptureLateTransactionAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\CaptureTransactionAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\ExternalPaymentSuccessAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\GetTransactionStatusAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\ReserveTransactionAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\ResetTransactionAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\AuthorizeAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\CaptureAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api\CreateTransactionAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\ConvertPaymentAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\NotifyAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\NotifyNullAction;
use Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\StatusAction;
use Lifestyle\Sylius\Crefopay\Api\CrefopayApi;
use Lifestyle\Sylius\Crefopay\Api\CrefopayApiFactory;
use Lifestyle\Sylius\Crefopay\Api\CrefopayApiRequestModelFactory;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\GatewayFactory;
use Upg\Library\Config;

/**
 * Class CrefopayHostedPageBeforeGatewayFactory
 *
 * @package Lifestyle\Sylius\RestApiClientBundle
 */
class CrefopayHostedPageBeforeGatewayFactory extends GatewayFactory
{
    /**
     * @inheritDoc
     */
    protected function populateConfig(ArrayObject $config)
    {
        $config->defaults([
            'payum.factory_name' => 'crefopay_hostedbefore',
            'payum.factory_title' => 'Crefopay HostedPageBefore',
            'payum.template.authorize' => '@LifestyleSyliusCrefopayPlugin/paymentBefore.html.twig',
            'payum.helper.router' => '@router',
            'payum.helper.payum' => '@payum',
            'payum.helper.notificationProcessor' => '@Lifestyle\Sylius\Crefopay\Processor\NotificationProcessor',
            'payum.helper.orderRepository' => '@sylius.repository.order',
        ]);
        $config->defaults([
            'payum.action.authorize' => new AuthorizeAction($config['payum.template.authorize']),
            'payum.action.capture' => new CaptureAction(),
            'payum.action.status' => new StatusAction(),
            'payum.action.notify' => new NotifyAction(),
            'payum.action.notify_null' => new NotifyNullAction(),
            'payum.action.convert_payment' => new ConvertPaymentAction(),
            'payum.action.api.create_transaction' => new CreateTransactionAction(),
            'payum.action.api.reserve_transaction' => new ReserveTransactionAction(),
            'payum.action.api.capture_transaction' => new CaptureTransactionAction(),
            'payum.action.api.capture_late_transaction' => new CaptureLateTransactionAction(),
            'payum.action.api.external_payment_success' => new ExternalPaymentSuccessAction(),
            'payum.action.api.get_transaction' => new GetTransactionStatusAction(),
            'payum.action.api.reset_transaction' => new ResetTransactionAction(),
        ]);

        if (false == $config['payum.api']) {
            $config['payum.api'] = function (ArrayObject $config) {
                $apiConfig = new Config([
                    'baseUrl' => (true === $config['sandbox'])? CrefopayApi::SANDBOX_API : CrefopayApi::PRODUCTION_API,
                    'merchantPassword' => $config['privateKey'],
                    'merchantID' => $config['merchantId'],
                    'storeID' => $config['storeId'],
                ]);

                return new CrefopayApi(
                    $apiConfig,
                    new CrefopayApiFactory($apiConfig, $config['payum.helper.notificationProcessor']),
                    new CrefopayApiRequestModelFactory($apiConfig),
                    $config['payum.helper.router'],
                    $config['payum.helper.payum'],
                    $config['payum.helper.orderRepository']
                );
            };
        }
    }
}
