<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Entity;

use Lifestyle\Sylius\Crefopay\Security\Util\RandomTokenGenerator;
use Sylius\Bundle\PayumBundle\Model\PaymentSecurityToken as BasePaymentSecurityToken;
use Sylius\Bundle\PayumBundle\Model\PaymentSecurityTokenInterface;

/**
 * Class PaymentSecurityToken
 *
 * @package Lifestyle\Sylius\Crefopay\Model
 */
class PaymentSecurityToken extends BasePaymentSecurityToken implements PaymentSecurityTokenInterface
{
    /**
     * @var array
     */
    protected $urlParameters;

    /**
     * PaymentSecurityToken constructor.
     *
     * Overwrite token generator as we need tokens limited to 30 chars for crefopay
     */
    public function __construct()
    {
        parent::__construct();
        $this->hash = RandomTokenGenerator::generateToken(30);
    }

    /**
     * @return array
     */
    public function getUrlParameters(): array
    {
        return $this->urlParameters;
    }

    /**
     * @param array $urlParameters
     */
    public function setUrlParameters(array $urlParameters): void
    {
        $this->urlParameters = $urlParameters;
    }
}
