<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\DataModelPlugin\Tests;

use LifeStyle\Sylius\DataModelPlugin\Entity\MerchantLocations;
use PHPUnit\Framework\TestCase;

/**
 * Class MerchantLocationsTest
 * @package LifeStyle\Sylius\DataModelPlugin\Tests
 */
class MerchantLocationsTest extends TestCase
{

    public function testDataModel()
    {
        $model = new MerchantLocations();

        $model->setId(1);
        $this->assertEquals(1, $model->getId());

        $model->setCode('code');
        $this->assertEquals('code', $model->getCode());

        $model->setCompany('company');
        $this->assertEquals('company', $model->getCompany());

        $model->setAddress('address');
        $this->assertEquals('address', $model->getAddress());

        $model->setPostalCode('postalCode');
        $this->assertEquals('postalCode', $model->getPostalCode());

        $model->setCity('city');
        $this->assertEquals('city', $model->getCity());

        $model->setCountry('country');
        $this->assertEquals('country', $model->getCountry());

        $model->setPhone('phone');
        $this->assertEquals('phone', $model->getPhone());

        $model->setFax('fax');
        $this->assertEquals('fax', $model->getFax());

        $model->setEmail('email');
        $this->assertEquals('email', $model->getEmail());

        $model->setWebAddress('webAddress');
        $this->assertEquals('webAddress', $model->getWebAddress());

        $model->setNotes('notes');
        $this->assertEquals('notes', $model->getNotes());

        $model->setLatitude('latitude');
        $this->assertEquals('latitude', $model->getLatitude());

        $model->setLongitude('longitude');
        $this->assertEquals('longitude', $model->getLongitude());

        $model->setActive(true);
        $this->assertEquals(true, $model->getActive());

        $model->setCreated(new \DateTime('1976-04-23'));
        $this->assertEquals(new \DateTime('1976-04-23'), $model->getCreated());

        $model->setUpdated(new \DateTime('2019-04-23'));
        $this->assertEquals(new \DateTime('2019-04-23'), $model->getUpdated());

        //lifecycle  callback
        $model->renewUpdated();
        $this->assertNotEquals(new \DateTime('2019-04-23'), $model->getUpdated());
    }

}
