<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Customer\Model\CustomerGroup as CustomerGroupBase;

/**
 * Class CustomerGroup
 * @package LifeStyle\Sylius\PricingPlugin\Entity
 */
class CustomerGroup extends CustomerGroupBase implements CustomerGroupInterface
{
    /**
     * @var ArrayCollection|PriceList[]
     */
    private $priceLists;

    /**
     * CustomerGroup constructor.
     */
    public function __construct()
    {
        $this->priceLists = new ArrayCollection();
    }

    /**
     * @return Collection|PriceList[]
     */
    public function getPriceLists(): Collection
    {
        return $this->priceLists;
    }

    /**
     * @param Collection|PriceList $priceLists
     */
    public function setPriceLists(Collection $priceLists): void
    {
        $this->priceLists = $priceLists;
    }

    /**
     * @param PriceList $priceList
     */
    public function addPriceLists(PriceList $priceList): void
    {
        if (!$this->priceLists->contains($priceList)) {
            $this->priceLists->add($priceList);
        }
    }
}
