<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\DataModelPlugin\Tests\Entity\DependencyInjection;

use LifeStyle\Sylius\DataModelPlugin\DependencyInjection\Configuration;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Config\Definition\Processor;

/**
 * Class ConfigurationTest
 * @package LifeStyle\Sylius\DataModelPlugin\Tests\Entity\DependencyInjection
 */
class ConfigurationTest extends TestCase
{

    public function testDataModel()
    {
        $configs = [];
        $config = $this->process($configs);

        //because no config set in tree builder
        $this->assertTrue(empty($config));
    }

    /**
     * @param array $configs
     * @return array
     */
    private function process($configs)
    {
        $processor = new Processor();
        return $processor->processConfiguration(new Configuration(), $configs);
    }
}
