<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Resource\Model\ResourceInterface;

/**
 * Class CustomDiscount
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class CustomDiscount implements ResourceInterface, CustomDiscountInterface
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var integer
     */
    private $discount;

    /**
     * @var string
     */
    private $type;

    /**
     * @var ChannelInterface|null
     */
    private $channel;

    /**
     * @var ProductVariantInterface
     */
    private $productVariant;

    /**
     * @var PriceList
     */
    private $priceList;

    /**
     * CustomDiscount constructor.
     * @param string $type
     * @param integer $discount
     */
    public function __construct(string $type = '', int $discount = 0)
    {
        $this->type = $type;
        $this->discount = $discount;
    }

    /**
     * @return int|mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return integer
     */
    public function getDiscount(): int
    {
        return $this->discount;
    }

    /**
     * @param int|null $discount
     */
    public function setDiscount(?int $discount): void
    {
        $this->discount = $discount;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @return ProductVariantInterface
     */
    public function getProductVariant(): ProductVariantInterface
    {
        return $this->productVariant;
    }

    /**
     * @param ProductVariantInterface $productVariants
     * @return void
     */
    public function setProductVariant(ProductVariantInterface $productVariants): void
    {
        $this->productVariant = $productVariants;
    }

    /**
     * @return ChannelInterface|null
     */
    public function getChannel(): ?ChannelInterface
    {
        return $this->channel;
    }

    /**
     * @param ChannelInterface|null $channel
     */
    public function setChannel(?ChannelInterface $channel): void
    {
        $this->channel = $channel;
    }

    /**
     * @return PriceList|null
     */
    public function getPriceList(): ?PriceList
    {
        return $this->priceList;
    }

    /**
     * @param PriceList $priceList
     */
    public function setPriceList(PriceList $priceList): void
    {
        $this->priceList = $priceList;
    }
}
