<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use LifeStyle\Sylius\DataModelPlugin\Entity\AssetStorageInterface;
use LifeStyle\Sylius\DataModelPlugin\Entity\CustomDiscount;
use LifeStyle\Sylius\DataModelPlugin\Entity\TierPrice;
use Sylius\Component\Core\Model\ProductVariantInterface as BaseProductVariantInterface;
use Sylius\Component\Resource\Model\ToggleableInterface;
use Doctrine\Common\Collections\Collection;

/**
 * Interface ProductVariantInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\ProductVariant\Entity
 */
interface ProductVariantInterface extends BaseProductVariantInterface, ToggleableInterface
{
    /**
     * @return string|null
     */
    public function getSku(): ?string;

    /**
     * @param string|null $sku
     */
    public function setSku(?string $sku): void;

    /**
     * @return Collection
     */
    public function getAssets(): Collection;

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function addAsset(AssetStorageInterface $assetStorage): void;

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function removeAsset(AssetStorageInterface $assetStorage): void;

    /**
     * @param AssetStorageInterface $assetStorage
     * @return bool
     */
    public function hasAsset(AssetStorageInterface $assetStorage): bool;

    /**
     * @return bool
     */
    public function hasAssets();

    /**
     * @param TierPrice $tierPrice
     */
    public function removeTierPrice(TierPrice $tierPrice): void;

    /**
     * @param TierPrice $tierPrice
     */
    public function addTierPrice(TierPrice $tierPrice): void;

    /**
     * @param CustomDiscount $customDiscount
     */
    public function removeCustomDiscount(CustomDiscount $customDiscount): void;

    /**
     * @param CustomDiscount $customDiscount
     */
    public function addCustomDiscount(CustomDiscount $customDiscount): void;
}
