<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Class Version20190129133844
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package DoctrineMigrations
 */
final class Version20190129133844 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE ls_tier_prices (id INT AUTO_INCREMENT NOT NULL, channel_id INT DEFAULT NULL, price INT NOT NULL, qty INT NOT NULL, priceList_id INT DEFAULT NULL, productVariant_id INT DEFAULT NULL, INDEX IDX_255EBB9D46B960C4 (priceList_id), INDEX IDX_255EBB9D72F5A1AA (channel_id), INDEX IDX_255EBB9D5708BDEF (productVariant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE ls_price_list (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) DEFAULT NULL, enabled TINYINT(1) DEFAULT NULL, created DATETIME DEFAULT NULL, updated DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE ls_customer_group_2_price_list (price_list_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_EB402B6B5688DED7 (price_list_id), INDEX IDX_EB402B6BFE54D947 (group_id), PRIMARY KEY(price_list_id, group_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE ls_custom_discounts (id INT AUTO_INCREMENT NOT NULL, channel_id INT DEFAULT NULL, discount INT NOT NULL, type VARCHAR(255) NOT NULL, priceList_id INT DEFAULT NULL, productVariant_id INT DEFAULT NULL, INDEX IDX_A4E0FB0946B960C4 (priceList_id), INDEX IDX_A4E0FB0972F5A1AA (channel_id), INDEX IDX_A4E0FB095708BDEF (productVariant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE ls_tier_prices ADD CONSTRAINT FK_255EBB9D46B960C4 FOREIGN KEY (priceList_id) REFERENCES ls_price_list (id)');
        $this->addSql('ALTER TABLE ls_tier_prices ADD CONSTRAINT FK_255EBB9D72F5A1AA FOREIGN KEY (channel_id) REFERENCES sylius_channel (id)');
        $this->addSql('ALTER TABLE ls_tier_prices ADD CONSTRAINT FK_255EBB9D5708BDEF FOREIGN KEY (productVariant_id) REFERENCES sylius_product_variant (id)');
        $this->addSql('ALTER TABLE ls_customer_group_2_price_list ADD CONSTRAINT FK_EB402B6B5688DED7 FOREIGN KEY (price_list_id) REFERENCES ls_price_list (id)');
        $this->addSql('ALTER TABLE ls_customer_group_2_price_list ADD CONSTRAINT FK_EB402B6BFE54D947 FOREIGN KEY (group_id) REFERENCES sylius_customer_group (id)');
        $this->addSql('ALTER TABLE ls_custom_discounts ADD CONSTRAINT FK_A4E0FB0946B960C4 FOREIGN KEY (priceList_id) REFERENCES ls_price_list (id)');
        $this->addSql('ALTER TABLE ls_custom_discounts ADD CONSTRAINT FK_A4E0FB0972F5A1AA FOREIGN KEY (channel_id) REFERENCES sylius_channel (id)');
        $this->addSql('ALTER TABLE ls_custom_discounts ADD CONSTRAINT FK_A4E0FB095708BDEF FOREIGN KEY (productVariant_id) REFERENCES sylius_product_variant (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE ls_tier_prices DROP FOREIGN KEY FK_255EBB9D46B960C4');
        $this->addSql('ALTER TABLE ls_customer_group_2_price_list DROP FOREIGN KEY FK_EB402B6B5688DED7');
        $this->addSql('ALTER TABLE ls_custom_discounts DROP FOREIGN KEY FK_A4E0FB0946B960C4');
        $this->addSql('DROP TABLE ls_tier_prices');
        $this->addSql('DROP TABLE ls_price_list');
        $this->addSql('DROP TABLE ls_customer_group_2_price_list');
        $this->addSql('DROP TABLE ls_custom_discounts');
    }
}
