<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Resource\Model\ResourceInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Location
 *
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class Location implements ResourceInterface
{
    /**
     * @var int
     */
    private $id;

    /**
     * @Assert\NotBlank
     * @Assert\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Assert\NotNull
     * @Assert\Type("LifeStyle\Sylius\DataModelPlugin\Entity\Address")
     * @var AddressInterface
     */
    private $billingAddress;

    /**
     * @Assert\NotNull
     * @Assert\Type("LifeStyle\Sylius\DataModelPlugin\Entity\Address")
     * @var AddressInterface
     */
    private $shippingAddress;

    /**
     * @Assert\Type("float")
     * @var float
     */
    private $geopointLatitude;

    /**
     * @Assert\Type("float")
     * @var float
     */
    private $geopointLongitude;

    /**
     * @Assert\NotBlank
     * @Assert\Type("int")
     * @var int
     */
    private $code;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Location
     */
    public function setName(string $name): Location
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return Location
     */
    public function setCode(int $code): Location
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return AddressInterface
     */
    public function getBillingAddress(): AddressInterface
    {
        return $this->billingAddress;
    }

    /**
     * @param AddressInterface $billingAddress
     *
     * @return Location
     */
    public function setBillingAddress(AddressInterface $billingAddress): Location
    {
        $this->billingAddress = $billingAddress;

        return $this;
    }

    /**
     * @return AddressInterface
     */
    public function getShippingAddress(): AddressInterface
    {
        return $this->shippingAddress;
    }

    /**
     * @param AddressInterface $shippingAddress
     *
     * @return Location
     */
    public function setShippingAddress(AddressInterface $shippingAddress): Location
    {
        $this->shippingAddress = $shippingAddress;

        return $this;
    }

    /**
     * @return float
     */
    public function getGeopointLatitude(): float
    {
        return $this->geopointLatitude;
    }

    /**
     * @param float $geopointLatitude
     *
     * @return Location
     */
    public function setGeopointLatitude(float $geopointLatitude): Location
    {
        $this->geopointLatitude = $geopointLatitude;

        return $this;
    }

    /**
     * @return float
     */
    public function getGeopointLongitude(): float
    {
        return $this->geopointLongitude;
    }

    /**
     * @param float $geopointLongitude
     *
     * @return Location
     */
    public function setGeopointLongitude(float $geopointLongitude): Location
    {
        $this->geopointLongitude = $geopointLongitude;

        return $this;
    }
}
