<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Class Version20190412095639
 *
 * @package DoctrineMigrations
 */
final class Version20190412095639 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE ls_location (id INT AUTO_INCREMENT NOT NULL, billing_address_id INT DEFAULT NULL, shipping_address_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, geopoint_latitude DOUBLE PRECISION DEFAULT NULL, geopoint_longitude DOUBLE PRECISION DEFAULT NULL, code INT DEFAULT NULL, INDEX IDX_BA60538D79D0C0E4 (billing_address_id), INDEX IDX_BA60538D4D4CFF2B (shipping_address_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE ls_location ADD CONSTRAINT FK_BA60538D79D0C0E4 FOREIGN KEY (billing_address_id) REFERENCES sylius_address (id)');
        $this->addSql('ALTER TABLE ls_location ADD CONSTRAINT FK_BA60538D4D4CFF2B FOREIGN KEY (shipping_address_id) REFERENCES sylius_address (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('DROP TABLE ls_location');
    }
}
