<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Sylius\Component\Core\Model\Address as BaseAddress;

/**
 * Class Address
 *
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class Address extends BaseAddress
{
    /**
     * @var int|null
     */
    private $code;

    /**
     * @var int
     */
    private $masterAddress = 0;

    /**
     * @return int|null
     */
    public function getCode(): ?int
    {
        return $this->code;
    }

    /**
     * @param int|null $code
     */
    public function setCode(?int $code): void
    {
        $this->code = $code;
    }

    /**
     * @return int
     */
    public function getMasterAddress(): int
    {
        return $this->masterAddress;
    }

    /**
     * @param int $masterAddress
     */
    public function setMasterAddress(int $masterAddress): void
    {
        $this->masterAddress = $masterAddress;
    }
}
