<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Sylius\Component\Core\Model\Product as BaseProduct;
use LifeStyle\Sylius\DataModelPlugin\Entity\AssetStorage;
use LifeStyle\Sylius\DataModelPlugin\Entity\AssetStorageInterface;
use Doctrine\Common\Collections\Collection;

/**
 * Class Product
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class Product extends BaseProduct implements ProductInterface, ReviewableProductInterface
{
    /**
     * @var AssetStorage[]|ArrayCollection|null
     */
    protected $assets;

    /**
     * @var string|null
     */
    protected $concept;

    /**
     * Product constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->assets = new ArrayCollection();
    }

    /**
     * @return Collection
     */
    public function getAssets(): Collection
    {
        return $this->assets;
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function addAsset(AssetStorageInterface $assetStorage): void
    {
        if (!$this->hasAsset($assetStorage)) {
            $this->assets->add($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function removeAsset(AssetStorageInterface $assetStorage): void
    {
        if ($this->hasAsset($assetStorage)) {
            $this->assets->removeElement($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     * @return bool
     */
    public function hasAsset(AssetStorageInterface $assetStorage): bool
    {
        return $this->assets->contains($assetStorage);
    }

    /**
     * @return bool
     */
    public function hasAssets()
    {
        return $this->assets->count() !== 0 ? true : false;
    }

    /**
     * @return null|string
     */
    public function getConcept(): ?string
    {
        return $this->concept;
    }

    /**
     * @param null|string $concept
     *
     * @return Product
     */
    public function setConcept(?string $concept): Product
    {
        $this->concept = $concept;

        return $this;
    }
}
