<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Sylius\Component\Core\Model\ProductImage as BaseProductImage;

/**
 * Class ProductImage
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class ProductImage extends BaseProductImage implements ProductImageInterface
{
    /**
     * @var string
     */
    private $resourceId;

    /**
     * This is set to false if the image is connected to the product itself
     *
     * @var boolean
     */
    private $isRemovable;

    /**
     * @return string|null
     */
    public function getResourceId(): ?string
    {
        return $this->resourceId;
    }

    /**
     * @param string $resourceId
     */
    public function setResourceId(string $resourceId): void
    {
        $this->resourceId = $resourceId;
    }

    /**
     * @return bool
     */
    public function isRemovable(): bool
    {
        return (bool)$this->isRemovable;
    }

    /**
     * @param bool $isRemovable
     */
    public function setRemovable(bool $isRemovable): void
    {
        $this->isRemovable = $isRemovable;
    }
}
