<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Interface CustomDiscountInterface
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
interface CustomDiscountInterface
{
    /**
     * @return int
     */
    public function getDiscount(): int;

    /**
     * @param int|null $price
     */
    public function setDiscount(?int $discount): void;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $type
     */
    public function setType(string $type): void;

    /**
     * @return ProductVariantInterface
     */
    public function getProductVariant(): ProductVariantInterface;

    /**
     * @param ProductVariantInterface $productVariants
     */
    public function setProductVariant(ProductVariantInterface $productVariants): void;

    /**
     * @return mixed
     */
    public function getId();

    /**
     * @return ChannelInterface|null
     */
    public function getChannel(): ?ChannelInterface;

    /**
     * @param ChannelInterface|null $channel
     */
    public function setChannel(?ChannelInterface $channel): void;

    /**
     * @return PriceList|null
     */
    public function getPriceList(): ?PriceList;
}
