<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Sylius\Component\Resource\Model\ResourceInterface;

/**
 * Class AssetStorage
 * @package LifeStyle\Sylius\DataModelPlugin\Entity
 */
class AssetStorage implements ResourceInterface, AssetStorageInterface
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $resourceId;

    /**
     * @var string|null
     */
    private $path;

    /**
     * @var string|null
     */
    private $name;

    /**
     * @var \DateTime
     */
    private $created;

    /**
     * @var \DateTime
     */
    private $updated;

    /**
     * @var ArrayCollection|AssetStorageMetaDataInterface[]|null
     */
    private $metaDatas;

    /**
     * AssetStorage constructor.
     * @throws \Exception
     */
    public function __construct()
    {
        $this->created = new \DateTime();
        $this->updated = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getResourceId(): string
    {
        return $this->resourceId;
    }

    /**
     * @param string $resourceId
     */
    public function setResourceId(string $resourceId): void
    {
        $this->resourceId = $resourceId;
    }

    /**
     * @return string|null
     */
    public function getPath(): ?string
    {
        return $this->path;
    }

    /**
     * @param string|null $path
     */
    public function setPath(?string $path): void
    {
        $this->path = $path;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return \DateTime
     */
    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     */
    public function setCreated(\DateTime $created): void
    {
        $this->created = $created;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated(): \DateTime
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     */
    public function setUpdated(\DateTime $updated): void
    {
        $this->updated = $updated;
    }

    /**
     * @return ArrayCollection|AssetStorageMetaDataInterface[]|null
     */
    public function getMetaDatas()
    {
        return $this->metaDatas;
    }

    /**
     * @param AssetStorageMetaDataInterface $metaData
     */
    public function addMetaData(AssetStorageMetaDataInterface $metaData): void
    {
        if (null === $this->metaDatas) {
            $this->metaDatas = new ArrayCollection();
        }

        if (!$this->metaDatas->contains($metaData)) {
            $this->metaDatas->add($metaData);
        }
    }

    /**
     * @param AssetStorageMetaDataInterface $metaData
     */
    public function removeMetaData(AssetStorageMetaDataInterface $metaData)
    {
        if ($this->metaDatas->contains($metaData)) {
            $this->metaDatas->remove($metaData);
        }
    }

    /**
     * @throws \Exception
     */
    public function renewUpdated(): void
    {
        $this->updated = new \DateTime();
    }
}
