<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\DataModelPlugin\Form;

use LifeStyle\Sylius\DataModelPlugin\Entity\CustomerGroup;
use LifeStyle\Sylius\DataModelPlugin\Entity\PriceList;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class TierPriceType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sylius\PricingPlugin\Form
 */
class TierPriceListType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('id', IntegerType::class, [
            'required' => true,
            'attr' => [
                'style' => 'display:none;',
            ],
            'label_attr' => [
                'style' => 'display:none;',
            ],
        ]);

        $builder->add('name', TextType::class, [
            'required' => true,
        ]);

        $builder->add('enabled', CheckboxType::class, [
            'required' => true,
            'false_values' => [null, 0, '', '0', false, 'false'],
        ]);
        $builder->get('enabled')->addModelTransformer(new CallbackTransformer(
            function ($value) {
                return boolval($value);
            },
            function ($value) {
                return intval($value);
            }
        ));

        $builder->add('updated', DateTimeType::class, [
            'required' => false,
            'html5' => true,
            'widget' => 'single_text',
        ]);

        $builder->add('customerGroups', EntityType::class, [
            'required' => false,
            'class' => CustomerGroup::class,
            'multiple' => true,
            'choice_label' => 'id',
        ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PriceList::class,
        ]);
    }

    /**
     * @return string
     */
    public function getBlockPrefix(): string
    {
        return 'life_style_tier_price_list';
    }
}
