<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Klarna;

use Klarna\Rest\Transport\GuzzleConnector;
use Lifestyle\Sylius\Klarna\Action\Api\CreateSessionAction;
use Lifestyle\Sylius\Klarna\Action\Api\PlaceOrderAction;
use Lifestyle\Sylius\Klarna\Action\AuthorizeAction;
use Lifestyle\Sylius\Klarna\Action\CaptureAction;
use Lifestyle\Sylius\Klarna\Action\ConvertPaymentAction;
use Lifestyle\Sylius\Klarna\Action\StatusAction;
use Lifestyle\Sylius\Klarna\Api\KlarnaApi;
use Lifestyle\Sylius\Klarna\Api\KlarnaApiFactory;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\GatewayFactory;

/**
 * Class KlarnaRestApiGatewayFactory
 *
 * @package Lifestyle\Sylius\Klarna
 */
class KlarnaRestApiGatewayFactory extends GatewayFactory
{
    /**
     * @inheritDoc
     */
    protected function populateConfig(ArrayObject $config)
    {
        $config->defaults([
            'payum.factory_name' => 'klarna_restapi',
            'payum.factory_title' => 'Klarna Rest Api',
            'payum.template.authorize' => '@LifestyleSyliusKlarnaPlugin/paymentBefore.html.twig',
            'payum.helper.klarna_request' => '@Lifestyle\Sylius\Klarna\Service\KlarnaRequest',
        ]);

        $config->defaults([
            'payum.action.authorize' => new AuthorizeAction($config['payum.template.authorize'], $config),
            'payum.action.capture' => new CaptureAction(!$config['deactivate_capture']),
            'payum.action.status' => new StatusAction(),
            'payum.action.convert_payment' => new ConvertPaymentAction(),
            'payum.action.api.create_session' => new CreateSessionAction($config),
            'payum.action.api.place_order' => new PlaceOrderAction(),
        ]);

        if (false == $config['payum.api']) {
            $config['payum.api'] = function (ArrayObject $config) {
                $connector = GuzzleConnector::create(
                    $config['username'],
                    $config['password'],
                    (true === $config['sandbox'])? KlarnaApi::SANDBOX_API : KlarnaApi::PRODUCTION_API
                );

                return new KlarnaApi(
                    $connector,
                    new KlarnaApiFactory($connector),
                    $config['payum.helper.klarna_request']
                );
            };
        }
    }
}
