<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Klarna\Api;

use Klarna\Rest\Transport\GuzzleConnector;
use Lifestyle\Sylius\Klarna\Service\KlarnaRequest;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class KlarnaApi
 *
 * @package Lifestyle\Sylius\Klarna\Api
 */
class KlarnaApi
{
    const PRODUCTION_API = 'https://api.klarna.com/';
    const SANDBOX_API = 'https://api.playground.klarna.com/';

    /**
     * @var GuzzleConnector
     */
    protected $connector;
    /**
     * @var KlarnaApiFactory
     */
    protected $apiFactory;
    /**
     * @var KlarnaRequest
     */
    protected $klarnaRequest;

    /**
     * KlarnaApi constructor.
     *
     * @param GuzzleConnector $connector
     * @param KlarnaApiFactory $apiFactory
     * @param KlarnaRequest $klarnaRequest
     */
    public function __construct(
        GuzzleConnector $connector,
        KlarnaApiFactory $apiFactory,
        KlarnaRequest $klarnaRequest
    ) {
        $this->connector = $connector;
        $this->apiFactory = $apiFactory;
        $this->klarnaRequest = $klarnaRequest;
    }

    /**
     * @return GuzzleConnector
     */
    public function getConnector(): GuzzleConnector
    {
        return $this->connector;
    }

    /**
     * @return KlarnaApiFactory
     */
    public function getApiFactory(): KlarnaApiFactory
    {
        return $this->apiFactory;
    }

    /**
     * @return KlarnaRequest
     */
    public function getKlarnaRequest(): KlarnaRequest
    {
        return $this->klarnaRequest;
    }
}
