<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Klarna\Action;

use ArrayAccess;
use Lifestyle\Sylius\Klarna\Action\Api\BaseApiAwareAction;
use Lifestyle\Sylius\Payum\Exception\CancelNotPayedException;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\Request\Cancel;
use Sylius\Component\Core\Model\OrderInterface;

/**
 * Class CancelAction
 * @package Lifestyle\Sylius\Klarna\Action
 */
class CancelAction extends BaseApiAwareAction
{
    /**
     * {@inheritDoc}
     *
     * @param Cancel $request
     * @throws CancelNotPayedException
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $details = ArrayObject::ensureArrayObject($request->getModel());

        /** @var OrderInterface $order */
        $orderManagementOrder = $this->api->getApiFactory()->orderManagementOrder($details['orderId']);
        $orderData = $orderManagementOrder->fetch();

        if ('CAPTURED' !== $orderData['status']) {
            throw new CancelNotPayedException();
        }
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return
            $request instanceof Cancel
            && $request->getModel() instanceof ArrayAccess
        ;
    }
}
