<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Klarna\Api;

use Klarna\Rest\OrderManagement\Order;
use Klarna\Rest\Payments\Orders;
use Klarna\Rest\Payments\Sessions;
use Klarna\Rest\Transport\GuzzleConnector;

/**
 * Class KlarnaApiFactory
 *
 * @package Lifestyle\Sylius\Klarna\Api
 */
class KlarnaApiFactory
{
    /**
     * @var GuzzleConnector
     */
    protected $connector;

    /**
     * KlarnaApiFactory constructor.
     *
     * @param GuzzleConnector $connector
     */
    public function __construct(
        GuzzleConnector $connector
    ) {
        $this->connector = $connector;
    }

    /**
     * @param null $sessionId
     *
     * @return Sessions
     */
    public function session($sessionId = null): Sessions
    {
        return new Sessions($this->connector, $sessionId);
    }

    /**
     * @param string $authToken
     *
     * @return Orders
     */
    public function order(string $authToken): Orders
    {
        return new Orders($this->connector, $authToken);
    }

    /**
     * @param string $orderId
     *
     * @return Order
     */
    public function orderManagementOrder(string $orderId): Order
    {
        return new Order($this->connector, $orderId);
    }
}
