<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Klarna\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;

/**
 * Class KlarnaRestApiGatewayConfigurationType
 *
 * @package Lifestyle\Sylius\Klarna\Form
 */
class KlarnaRestApiGatewayConfigurationType extends AbstractType
{
    /**
     * @inheritDoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('username', TextType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.username',
                'translation_domain' => 'admin',
                'constraints' => [
                    new NotBlank([
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.username_notblank',
                        'groups' => 'sylius',
                    ]),
                ],
            ])
            ->add('password', TextType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.password',
                'translation_domain' => 'admin',
                'constraints' => [
                    new NotBlank([
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.password_notblank',
                        'groups' => 'sylius',
                    ]),
                ],
            ])
            ->add('sandbox', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.sandbox',
                'translation_domain' => 'admin',
            ])
            ->add('disable_capture', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.disable_capture',
                'translation_domain' => 'admin',
            ])
            ->add('disable_pay_now', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.disable_pay_now',
                'translation_domain' => 'admin',
            ])
            ->add('disable_pay_later', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.disable_pay_later',
                'translation_domain' => 'admin',
            ])
            ->add('disable_pay_over_time', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.disable_pay_over_time',
                'translation_domain' => 'admin',
            ])
            ->add('authorize_mode', HiddenType::class, [
                'data' => 'use_authorize_before',
            ])
            ->add('template', ChoiceType::class, [
                'label' => 'sylius.form.gateway_configuration.klarna_rest.template',
                'translation_domain' => 'admin',
                'choices'  => [
                    'Bootstrap' => 'Bootstrap',
                    'Semantic' => 'Semantic',
                ],
            ])
            ->add('color_border', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_border',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_border_selected', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_border_selected',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_button', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_button',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_button_text', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_button_text',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_checkbox', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_checkbox',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_checkbox_checkmark', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_checkbox_checkmark',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_details', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_details',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_header', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_header',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_link', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_link',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_text', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_text',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('color_text_secondary', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.color_text_secondary',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '#ff0000'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.color_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
            ->add('radius_border', TextType::class, [
                'required' => false,
                'label' => 'sylius.form.gateway_configuration.klarna_rest.radius_border',
                'translation_domain' => 'admin',
                'attr' => ['placeholder' => '5px'],
                'constraints' => [
                    new Regex([
                        'pattern' => '/^\d{1,2} ?(px|pt|pc|cm|mm|in|em|ex|ch|rem|vw|vh|vmin|vmax|%)$/',
                        'message' => 'sylius.form.gateway_configuration.klarna_rest.border_validation',
                        'groups' => 'sylius',
                    ])
                ]
            ])
        ;
    }
}
