<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      Franz Weisflug
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Location\Consumer\Entity;

use Lifestyle\Sylius\Account\Consumer\Entity\Customer;
use Lifestyle\Sylius\Account\Consumer\Entity\Location as AccountLocation;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Location
 *
 * @package Lifestyle\Sylius\Location\Consumer\Entity
 */
class Location extends AccountLocation
{
    /**
     * @Assert\NotBlank
     * @Assert\Type("string")
     * @var string
     */
    private $concept;

    /**
     * @Assert\NotBlank
     * @Assert\Type("string")
     * @var string
     */
    private $restaurantNumber;

    /**
     * @Assert\NotNull
     * @Assert\Type("Lifestyle\Sylius\Account\Consumer\Entity\Customer")
     * @var Customer
     */
    private $customer;

    /**
     * @return string
     */
    public function getConcept(): string
    {
        return $this->concept;
    }

    /**
     * @param string $concept
     *
     * @return Location
     */
    public function setConcept(string $concept): Location
    {
        $this->concept = $concept;

        return $this;
    }

    /**
     * @return string
     */
    public function getRestaurantNumber(): string
    {
        return $this->restaurantNumber;
    }

    /**
     * @param string $restaurantNumber
     *
     * @return Location
     */
    public function setRestaurantNumber(string $restaurantNumber): Location
    {
        $this->restaurantNumber = $restaurantNumber;

        return $this;
    }

    /**
     * @return Customer
     */
    public function getCustomer(): Customer
    {
        return $this->customer;
    }

    /**
     * @param Customer $customer
     *
     * @return Location
     */
    public function setCustomer(Customer $customer): Location
    {
        $this->customer = $customer;

        return $this;
    }
}
