<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Class Version20190430085802
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package DoctrineMigrations
 */
final class Version20190430085802 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE ls_location ADD customer_id INT DEFAULT NULL, ADD restaurant_number VARCHAR(255) NOT NULL, ADD concept VARCHAR(255) NOT NULL');
        $this->addSql('ALTER TABLE ls_location ADD CONSTRAINT FK_BA60538D9395C3F3 FOREIGN KEY (customer_id) REFERENCES sylius_customer (id)');
        $this->addSql('CREATE INDEX IDX_BA60538D9395C3F3 ON ls_location (customer_id)');
    }

    public function down(Schema $schema) : void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE ls_location DROP FOREIGN KEY FK_BA60538D9395C3F3');
        $this->addSql('DROP INDEX IDX_BA60538D9395C3F3 ON ls_location');
        $this->addSql('ALTER TABLE ls_location DROP customer_id, DROP restaurant_number, DROP concept');
    }
}
