<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Lifestyle\Sylius\Location\Consumer\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\MessageResponsibilityTrait;
use Lifestyle\Sylius\Location\Consumer\Helper\DocumentHelper;

/**
 * Class AssetUnpublishHandler
 * @package Lifestyle\Sylius\Location\Consumer\MessageHandler
 */
class AssetUnpublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;

    /**
     * @var DocumentHelper
     */
    private $documentHelper;

    /**
     * AssetUnpublishHandler constructor.
     * @param DocumentHelper $documentHelper
     */
    public function __construct(DocumentHelper $documentHelper){
        $this->documentHelper = $documentHelper;
    }

    /**
     * @inheritDoc
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if ($this->isResponsible($dataCollector)) {
            $this->documentHelper->removeDocument($dataCollector->getItemValue('id'));
        }

        return false;
    }
}
