# Life-Style Symfony Bundle To Handle Location Updates for Reinhold Keller

This bundle receives messages from rabbitMQ and creates/updates extended Locations in Sylius.

## Requirements

Sylius 1.3

## Installation
Add the repository to your `composer.json`
```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliuslocationconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusregistrationextensionplugin.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/sylius-rest-client.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusaccountconsumerbundle.git"
    }
  ]
}
```
Install the package:
```bash
composer require lifestyle/sylius-account-consumer
```

### Add to bundles

If your Sylius is based on Symfony 3.4 or 4.x this is done by `composer`.

_config/bundles.php:_
```php
<?php

return [
    ...
    Lifestyle\Sylius\Account\Consumer\LifestyleSyliusAccountConsumer::class => ['all' => true],
];
```

## Configuration
Add the new config file `config/packages/lifestyle_sylius_location_consumer.yaml` to your main project packages configs
```yaml
imports:
- { resource: "@LifestyleSyliusLocationConsumer/Resources/config/config.yml" }

lifestyle_sylius_location_consumer:
  location:
    responsible_events:
      publish: [ 'location.publish' ]
      unpublish: [ 'location.unpublish' ]
  assets:
    package_name: 'bench_plan'
    json_manifest_path: '%env(EXTERNAL_ASSETS_FOLDER)%/%env(EXTERNAL_ASSETS_PATH)%/manifest.json'
    responsible_events:
      publish: [ 'asset.document.publish' ]
      unpublish: [ 'asset.document.unpublish' ]
```

Update the asset management in your project. The configuration of the asset-package, which has to be managed by this plugin, has to be updated:
```yaml
framework:
  assets:
    packages:
      bench_plan:
        version_strategy: 'Lifestyle\Sylius\Location\Consumer\Asset\VersionStrategy\JsonManifestVersionStrategy'
```

## DB-Migrations
Copy the migration files from `lifestyle-sylius-account-consumer/src/Migrations` to your projects `src/Migrations` folder.
