<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      Franz Weisflug
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Location\Consumer\DependencyInjection;

use Lifestyle\Sylius\Account\Consumer\DependencyInjection\LifestyleSyliusAccountConsumerExtension;
use Lifestyle\Sylius\Location\Consumer\Asset\VersionStrategy\JsonManifestVersionStrategy;
use Lifestyle\Sylius\Location\Consumer\Configuration\LocationConfiguration;
use Lifestyle\Sylius\Location\Consumer\MessageHandler\AssetPublishHandler;
use Lifestyle\Sylius\Location\Consumer\MessageHandler\AssetUnpublishHandler;
use Lifestyle\Sylius\Location\Consumer\MessageHandler\LocationPublishHandler;
use Lifestyle\Sylius\Location\Consumer\MessageHandler\LocationUnpublishHandler;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Class LifestyleSyliusLocationConsumerExtension
 *
 * @package Lifestyle\Sylius\Location\Consumer\DependencyInjection
 */
class LifestyleSyliusLocationConsumerExtension extends LifestyleSyliusAccountConsumerExtension
{
    /**
     * @inheritDoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new YamlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.yml');

        $this->configureAssetVersionStrategy($config, $container);
        $this->configureAssetConfiguration($config, $container);

        $this->configureMessageHandler(LocationPublishHandler::class, 'location', 'publish', $config, $container);
        $this->configureMessageHandler(LocationUnpublishHandler::class, 'location', 'unpublish', $config, $container);
        $this->configureMessageHandler(AssetPublishHandler::class, 'assets', 'publish', $config, $container);
        $this->configureMessageHandler(AssetUnpublishHandler::class, 'assets', 'unpublish', $config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureAssetVersionStrategy(array $config, ContainerBuilder $container)
    {
        if ($container->has(JsonManifestVersionStrategy::class)) {
            $definition = $container->findDefinition(JsonManifestVersionStrategy::class);
            $definition->setArgument(0, $config['assets']['json_manifest_path']);
        }
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureAssetConfiguration(array $config, ContainerBuilder $container)
    {
        if ($container->has(LocationConfiguration::class)) {
            $definition = $container->findDefinition(LocationConfiguration::class);
            $definition->setArgument(0, $config['assets']['package_name']);
        }
    }
}
