<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Lifestyle\Sylius\Location\Consumer\Configuration;

/**
 * Class LocationConfiguration
 * @package Lifestyle\Sylius\Location\Consumer\Configuration
 */
class LocationConfiguration
{
    /**
     * @var string
     */
    private $packageName;

    /**
     * LocationConfiguration constructor.
     * @param string $packageName
     */
    public function __construct(string $packageName)
    {
        $this->packageName = $packageName;
    }

    /**
     * @return string
     */
    public function getPackageName(): string
    {
        return $this->packageName;
    }

    /**
     * @param string $packageName
     * @return LocationConfiguration
     */
    public function setPackageName(string $packageName): LocationConfiguration
    {
        $this->packageName = $packageName;
        return $this;
    }
}
