<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      Franz Weisflug
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Location\Consumer\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @package Lifestyle\Sylius\Location\Consumer\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @inheritDoc
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_sylius_location_consumer')
                ->children()
                    ->arrayNode('location')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('assets')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                            ->scalarNode('json_manifest_path')
                                ->example('%kernel.project_dir%/public/assets/manifest.json')
                                ->info('This is the same as used in framework.assets.packages.PACKAGE_NAME.json_manifest_path')
                                ->isRequired()
                            ->end()
                            ->scalarNode('package_name')
                                ->example('bench_plan')
                                ->info('Set to package name of the external images asset configuration: framework.assets.packages.PACKAGE_NAME.')
                                ->isRequired()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
