<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\MerchantSearchPlugin\Admin;

use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

/**
 * Class AdminMerchantLocationsMenuListener
 * @package LifeStyle\Sylius\MerchantSearch\Admin
 */
class AdminMerchantLocationsMenuListener
{
    /**
     * @param MenuBuilderEvent $event
     */
    public function addAdminMenuItems(MenuBuilderEvent $event): void
    {
        //get the admin backend customers menu
        $customers = $event->getMenu()->getChild('customers');

        $customers
            ->addChild('merchantLocations', ['route' => 'life_style_admin_merchant_locations_index'])
            ->setLabel('life_style.ui.merchant_locations')
            ->setLabelAttribute('icon', 'world')
        ;
    }
}
