<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Entity;

use LifeStyle\Sylius\PricingPlugin\Traits\CustomDiscountableTrait;
use LifeStyle\Sylius\PricingPlugin\Traits\TierPriceableTrait;
use Sylius\Component\Core\Model\ProductVariant as BaseProductVariant;

/**
 * Class ProductVariant
 * @package LifeStyle\Sylius\PricingPlugin\Entity
 */
class ProductVariant extends BaseProductVariant implements ProductVariantInterface
{
    use TierPriceableTrait;
    use CustomDiscountableTrait;

    /**
     * ProductVariant constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->initTierPriceableTrait();
        $this->initCustomDiscountableTrait();
    }
}
