<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Form;

use LifeStyle\Sylius\PricingPlugin\Entity\PriceList;
use LifeStyle\Sylius\PricingPlugin\Entity\TierPrice;
use Sylius\Bundle\ChannelBundle\Form\Type\ChannelChoiceType;
use Sylius\Bundle\MoneyBundle\Form\Type\MoneyType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Range;
use Webmozart\Assert\Assert;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

/**
 * Class TierPriceType
 * @package LifeStyle\Sylius\PricingPlugin\Form
 */
class TierPriceType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        Assert::keyExists($options, 'currency');

        $builder->add('qty', NumberType::class, [
            'label' => 'sylius.ui.amount',
            'required' => true,
            'constraints' => [
                new Range([
                    'min' => 0,
                    'groups' => 'sylius',
                    'minMessage' => 'Quantity has to be positive',
                ]),
                new NotBlank(['groups' => 'sylius']),
            ],
        ]);

        $builder->add('price', MoneyType::class, [
            'label' => 'sylius.ui.price',
            'required' => true,
            'currency' => $options['currency'],
        ]);

        $builder->add('priceList', EntityType::class, [
            'class' => PriceList::class,
            'choice_label' => 'name',
            'attr' => ['class' => 'ui dropdown']
        ]);

        $builder->add('channel', ChannelChoiceType::class, [
            'attr' => ['style' => 'display:none'],
            'constraints' => [
                new NotBlank(['groups' => 'sylius']),
            ],
        ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setRequired(['currency']);
        $resolver->setDefaults([
            'data_class' => TierPrice::class,
            'currency' => 'USD',
        ]);
    }

    /**
     * @return string
     */
    public function getBlockPrefix(): string
    {
        return 'life_style_tier_price';
    }
}
