<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestData;

/**
 * Class RequestDataFactory
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestData
 */
class RequestDataFactory
{
    /**
     * @param string $channel
     * @param string $code
     * @param int $quantity
     * @param string $userId
     * @return RequestData
     */
    public function requestData(string $channel, string $code, int $quantity, string $userId): RequestData
    {
        return new RequestData($channel, $code, $quantity, $userId);
    }
}
