<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

/**
 * Class ResponseFactory
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class ResponseFactory
{
    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @return ShopUser
     */
    public function shopUser()
    {
        return new ShopUser();
    }

    /**
     * @return Channel
     */
    public function channel()
    {
        return new Channel();
    }

    /**
     * @return CalculatedPrices
     */
    public function calculatedPrices()
    {
        return new CalculatedPrices();
    }

    /**
     * @return TierPrice
     */
    public function tierPrice()
    {
        return new TierPrice();
    }


    /**
     * @return CustomDiscount
     */
    public function customDiscount()
    {
        return new CustomDiscount();
    }
}
