<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Entity;

use LifeStyle\Sylius\PricingPlugin\Traits\CustomDiscountableInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\TierPriceableInterface;
use Lifestyle\Sylius\ProductVariant\Entity\ProductVariantInterface as BaseProductVariantInterface;

/**
 * Interface ProductVariantInterface
 * @package LifeStyle\Sylius\PricingPlugin\Entity
 */
interface ProductVariantInterface extends BaseProductVariantInterface, TierPriceableInterface, CustomDiscountableInterface
{
    /**
     * @param TierPrice $tierPrice
     */
    public function removeTierPrice(TierPrice $tierPrice): void;

    /**
     * @param TierPrice $tierPrice
     */
    public function addTierPrice(TierPrice $tierPrice): void;

    /**
     * @param CustomDiscount $customDiscount
     */
    public function removeCustomDiscount(CustomDiscount $customDiscount): void;

    /**
     * @param CustomDiscount $customDiscount
     */
    public function addCustomDiscount(CustomDiscount $customDiscount): void;
}
