<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Services;

use LifeStyle\Sylius\PricingPlugin\Entity\CustomDiscountInterface;
use LifeStyle\Sylius\PricingPlugin\Repository\CustomDiscountRepositoryInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\CustomDiscountableInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\TierPriceableInterface;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Class TierPriceFinder
 * @package LifeStyle\Sylius\PricingPlugin\Services
 */
class CustomDiscountFinder implements CustomDiscountFinderInterface
{
    /**
     * @var CustomDiscountRepositoryInterface
     */
    private $customDiscountRepository;

    /**
     * CustomDiscountFinder constructor.
     * @param CustomDiscountRepositoryInterface $customDiscountRepository
     */
    public function __construct(CustomDiscountRepositoryInterface $customDiscountRepository)
    {
        $this->customDiscountRepository = $customDiscountRepository;
    }

    /**
     * @param CustomDiscountableInterface $customDiscountableEntity
     * @param ChannelInterface $channel
     * @param int $priceListId
     * @return int|null
     */
    public function find(
        CustomDiscountableInterface $customDiscountableEntity,
        ChannelInterface $channel,
        int $priceListId
    ): ?int {

        $possibleCustomDiscounts = $this->customDiscountRepository->getCustomDiscountsPrices(
            $customDiscountableEntity,
            $channel
        );

        /** @var CustomDiscountInterface[] $possibleCustomDiscounts */
        foreach ($possibleCustomDiscounts as $customDiscount) {
            if ($customDiscount->getPriceList()->getId() === $priceListId) {
                return $customDiscount->getDiscount();
            }
        };
        return null;
    }

    /**
     * @param CustomDiscountableInterface $customDiscountableEntity
     * @param ChannelInterface $channel
     * @param int $priceListId
     * @return CustomDiscountableInterface[]|null
     */
    public function findAll(
        CustomDiscountableInterface $customDiscountableEntity,
        ChannelInterface $channel,
        int $priceListId
    ) {
        $possibleCustomDiscounts = $this->customDiscountRepository->getCustomDiscountsPrices(
            $customDiscountableEntity,
            $channel
        );
        $customDiscountsArray = [];
        /** @var CustomDiscountInterface[] $possibleCustomDiscounts */
        foreach ($possibleCustomDiscounts as $customDiscount) {
            if ($customDiscount->getPriceList()->getId() === $priceListId) {
                $customDiscountsArray[] = $customDiscount;
            }
        };

        return $customDiscountsArray;
    }
}
