<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request\Version1;

use LifeStyle\Sylius\PricingPlugin\ShopApi\Exception\InvalidRequestParameterException;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestData\RequestData;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestData\RequestDataFactory;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestParserInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class RequestParser
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request\Version1
 */
class RequestParser implements RequestParserInterface
{
    /**
     * @var ValidatorInterface
     */
    private $validator;

    /**
     * @var RequestDataFactory
     */
    private $requestDataFactory;

    /**
     * RequestParser constructor.
     * @param ValidatorInterface $validator
     */
    public function __construct(ValidatorInterface $validator)
    {
        $this->validator = $validator;
        $this->requestDataFactory = new RequestDataFactory();
    }

    /**
     * @param Request $request
     * @return RequestData
     */
    public function parse(Request $request): RequestData
    {

        $queryParameters = new QueryParameters(
            $request->attributes->get('channel', ''),
            $request->attributes->get('code',''),
            (int)$request->query->get('quantity', ''),
            $request->query->get('userId', '')
        );

        $violations = $this->validator->validate($queryParameters);
        if (0 < count($violations)) {
            $errorMessages = [];
            foreach ($violations as $violation) {
                $errorMessages[] = $violation->getMessage();
            }
            throw new InvalidRequestParameterException(implode(' ', $errorMessages));
        }

        return $this->requestDataFactory->requestData(
            $queryParameters->getChannel(),
            $queryParameters->getCode(),
            $queryParameters->getQuantity(),
            $queryParameters->getUserId()
        );
    }
}