<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\ResponseInterface;

/**
 * Class Channel
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class Channel
{
    /**
     * @var integer
     */
    private $channelId;

    /**
     * @var string
     */
    private $channelCode;

    /**
     * @var string
     */
    private $channelName;

    /**
     * @var boolean
     */
    private $channelEnabled;

    /**
     * @var integer|null
     */
    private $baseCurrencyId;

    /**
     * @var string|null
     */
    private $baseCurrencyCode;

    /**
     * @param int $channelId
     */
    public function setChannelId(int $channelId): void
    {
        $this->channelId = $channelId;
    }

    /**
     * @param string $channelCode
     */
    public function setChannelCode(string $channelCode): void
    {
        $this->channelCode = $channelCode;
    }

    /**
     * @param string $channelName
     */
    public function setChannelName(string $channelName): void
    {
        $this->channelName = $channelName;
    }

    /**
     * @param bool $channelEnabled
     */
    public function setChannelEnabled(bool $channelEnabled): void
    {
        $this->channelEnabled = $channelEnabled;
    }

    /**
     * @param int|null $baseCurrencyId
     */
    public function setBaseCurrencyId(?int $baseCurrencyId): void
    {
        $this->baseCurrencyId = $baseCurrencyId;
    }

    /**
     * @param string|null $baseCurrencyCode
     */
    public function setBaseCurrencyCode(?string $baseCurrencyCode): void
    {
        $this->baseCurrencyCode = $baseCurrencyCode;
    }
}