<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\ResponseInterface;

/**
 * Class Response
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class Response implements ResponseInterface
{
    /**
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @var string
     */
    private $productVariantCode;

    /**
     * @var integer
     */
    private $productVariantId;

    /**
     * @var string|null
     */
    private $productCode;

    /**
     * @var integer
     */
    private $productId;

    /**
     * @var string|null
     */
    private $productName;

    /**
     * @var ShopUser|null
     */
    private $shopUser;

    /**
     * @var Channel
     */
    private $channel;

    /**
     * @var CalculatedPrices
     */
    private $calculatedPrices;

    /**
     * @var ArrayCollection|TierPrice[]
     */
    private $tierPrices;

    /**
     * @var ArrayCollection|CustomDiscount
     */
    private $customDiscounts;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->tierPrices = new ArrayCollection();
        $this->customDiscounts = new ArrayCollection();
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec(float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param string $productVariantCode
     */
    public function setProductVariantCode(string $productVariantCode): void
    {
        $this->productVariantCode = $productVariantCode;
    }

    /**
     * @param int $productVariantId
     */
    public function setProductVariantId(int $productVariantId): void
    {
        $this->productVariantId = $productVariantId;
    }

    /**
     * @param string|null $productCode
     */
    public function setProductCode(?string $productCode): void
    {
        $this->productCode = $productCode;
    }

    /**
     * @param int $productId
     */
    public function setProductId(int $productId): void
    {
        $this->productId = $productId;
    }

    /**
     * @param string|null $productName
     */
    public function setProductName(?string $productName): void
    {
        $this->productName = $productName;
    }

    /**
     * @param ShopUser|null $shopUser
     */
    public function setShopUser(?ShopUser $shopUser): void
    {
        $this->shopUser = $shopUser;
    }

    /**
     * @param Channel $channel
     */
    public function setChannel(Channel $channel): void
    {
        $this->channel = $channel;
    }

    /**
     * @param CalculatedPrices $calculatedPrices
     */
    public function setCalculatedPrices(CalculatedPrices $calculatedPrices): void
    {
        $this->calculatedPrices = $calculatedPrices;
    }

    /**
     * @param TierPrice $tierPrice
     */
    public function addTierPrice(TierPrice $tierPrice): void
    {
        $this->tierPrices->add($tierPrice);
    }

    /**
     * @param CustomDiscount $customDiscount
     */
    public function addCustomDiscount(CustomDiscount $customDiscount): void
    {
        $this->customDiscounts->add($customDiscount);
    }
}
