<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice;

use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData\ResponseData;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\ResponseInterface;

/**
 * Interface ResponseBuilderInterface
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice
 */
interface ResponseBuilderInterface
{
    /**
     * @param ResponseData $responseData
     * @return ResponseInterface
     */
    public function buildResponse(ResponseData $responseData): ResponseInterface;
}
