<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Doctrine\Common\Collections\ArrayCollection;
use LifeStyle\Sylius\PricingPlugin\Entity\CustomDiscount;

/**
 * Class ChannelData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class ChannelData
{
    /**
     * @var integer
     */
    private $channelId;

    /**
     * @var string
     */
    private $channelCode;

    /**
     * @var string
     */
    private $channelName;

    /**
     * @var boolean
     */
    private $channelEnabled;

    /**
     * @var integer|null
     */
    private $baseCurrencyId;

    /**
     * @var string|null
     */
    private $baseCurrencyCode;

    /**
     * @var TierPriceData[]|ArrayCollection
     */
    private $tierPrices;

    /**
     * @var CustomDiscount[]|ArrayCollection
     */
    private $customDiscounts;

    /**
     * ChannelData constructor.
     */
    public function __construct()
    {
        $this->tierPrices = new ArrayCollection();
        $this->customDiscounts = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getChannelId(): int
    {
        return $this->channelId;
    }

    /**
     * @param int $channelId
     */
    public function setChannelId(int $channelId): void
    {
        $this->channelId = $channelId;
    }

    /**
     * @return string
     */
    public function getChannelCode(): string
    {
        return $this->channelCode;
    }

    /**
     * @param string $channelCode
     */
    public function setChannelCode(string $channelCode): void
    {
        $this->channelCode = $channelCode;
    }

    /**
     * @return string
     */
    public function getChannelName(): string
    {
        return $this->channelName;
    }

    /**
     * @param string $channelName
     */
    public function setChannelName(string $channelName): void
    {
        $this->channelName = $channelName;
    }

    /**
     * @return bool
     */
    public function isChannelEnabled(): bool
    {
        return $this->channelEnabled;
    }

    /**
     * @param bool $channelEnabled
     */
    public function setChannelEnabled(bool $channelEnabled): void
    {
        $this->channelEnabled = $channelEnabled;
    }

    /**
     * @return int|null
     */
    public function getBaseCurrencyId(): ?int
    {
        return $this->baseCurrencyId;
    }

    /**
     * @param int|null $baseCurrencyId
     */
    public function setBaseCurrencyId(?int $baseCurrencyId): void
    {
        $this->baseCurrencyId = $baseCurrencyId;
    }

    /**
     * @return string|null
     */
    public function getBaseCurrencyCode(): ?string
    {
        return $this->baseCurrencyCode;
    }

    /**
     * @param string|null $baseCurrencyCode
     */
    public function setBaseCurrencyCode(?string $baseCurrencyCode): void
    {
        $this->baseCurrencyCode = $baseCurrencyCode;
    }

    /**
     * @return ArrayCollection|TierPriceData[]
     */
    public function getTierPrices()
    {
        return $this->tierPrices;
    }

    /**
     * @param ArrayCollection|TierPriceData[] $tierPrices
     */
    public function addTierPrice(TierPriceData $tierPrice): void
    {
        if (!$this->tierPrices->contains($tierPrice)) {
            $this->tierPrices->add($tierPrice);
        }
    }

    /**
     * @return ArrayCollection|CustomDiscount[]
     */
    public function getCustomDiscounts()
    {
        return $this->customDiscounts;
    }

    /**
     * @param CustomDiscount $customDiscount
     */
    public function addCustomDiscount(CustomDiscount $customDiscount): void
    {
        if (!$this->customDiscounts->contains($customDiscount)) {
            $this->customDiscounts->add($customDiscount);
        }
    }
}
