<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Traits;

use LifeStyle\Sylius\PricingPlugin\Entity\ProductVariant;
use LifeStyle\Sylius\PricingPlugin\Entity\TierPrice;
use LifeStyle\Sylius\PricingPlugin\Entity\TierPriceInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ProductVariantInterface;

/**
 * Trait TierPriceableTrait
 * @package LifeStyle\Sylius\PricingPlugin\Traits
 */
trait TierPriceableTrait
{
    /**
     * @var ArrayCollection
     */
    protected $tierPrices;

    /**
     * @return void
     */
    public function initTierPriceableTrait(): void
    {
        $this->tierPrices = new ArrayCollection();
    }

    /**
     * @return TierPriceInterface[]
     */
    public function getTierPrices(): array
    {
        return $this->tierPrices->toArray();
    }

    /**
     * @param ChannelInterface $channel
     * @return TierPriceInterface[]
     */
    public function getTierPricesForChannel(ChannelInterface $channel): array
    {
        return array_filter($this->getTierPrices(), function (TierPrice $tierPrice) use ($channel) {
            $tierPriceChannel = $tierPrice->getChannel();

            return $tierPriceChannel === null ? false : $tierPriceChannel->getId() === $channel->getId();
        });
    }

    /**
     * @param ChannelInterface $channel
     * @param int|null $priceListId
     * @return array
     */
    public function getTierPricesForChannelAndPriceList(ChannelInterface $channel, int $priceListId = null): array
    {
        if(null === $priceListId){
            return [];
        }

        return array_filter($this->getTierPrices(), function (TierPrice $tierPrice) use ($channel, $priceListId) {

            $tierPriceChannel = $tierPrice->getChannel();

            return $tierPriceChannel === null ? false : $tierPriceChannel->getId() === $channel->getId()
                && $tierPrice->getPriceList()->getId() === $priceListId;
                ;
        });
    }

    /**
     * @param TierPrice $tierPrice
     */
    public function removeTierPrice(TierPrice $tierPrice): void
    {
        $this->tierPrices->removeElement($tierPrice);
    }

    /**
     * @param TierPrice $tierPrice
     */
    public function addTierPrice(TierPrice $tierPrice): void
    {
        $tierPrice->setProductVariant($this);
        $this->tierPrices->add($tierPrice);
    }

    /**
     * @param array $tierPrices
     */
    public function setTierPrices(array $tierPrices): void
    {
        if (!$this instanceof ProductVariantInterface) {
            return;
        }

        $this->tierPrices = new ArrayCollection();

        foreach ($tierPrices as $tierPrice) {
            /** @var TierPrice $tierPrice */
            $this->addTierPrice($tierPrice);
        }
    }
}
