<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Menu;

use Sylius\Bundle\AdminBundle\Event\ProductMenuBuilderEvent;
use Symfony\Component\Translation\Translator;

final class AdminProductFormMenuListener
{
    /**
     * @var Translator
     */
    private $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    public function addItems(ProductMenuBuilderEvent $event): void
    {
        $menu = $event->getMenu();

        if ($event->getProduct()->isConfigurable()) {
            return;
        }

        $tab = '@LifeStyleSyliusPricingPlugin/Resources/views/Admin/ProductVariant/Tab/tier_price.html.twig';
        $menu
            ->addChild('tierprice')
            ->setAttribute('template', $tab)
            ->setLabel($this->translator->trans('life_style.ui.tier_price'))
            ->setLabelAttribute('icon', 'dollar');

        $tab_custom_discounts = '@LifeStyleSyliusPricingPlugin/Resources/views/Admin/ProductVariant/Tab/custom_discounts.html.twig';
        $menu
            ->addChild('custom_discounts', ['position' => 2])
            ->setAttribute('template', $tab_custom_discounts)
            ->setLabel($this->translator->trans('life_style.ui.custom_discounts'))
            ->setLabelAttribute('icon', 'dollar');
    }
}
