<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Repository;

use LifeStyle\Sylius\PricingPlugin\Entity\CustomDiscountInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\CustomDiscountableInterface;
use Doctrine\Common\Persistence\ObjectRepository;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Interface TierPriceRepositoryInterface
 * @package LifeStyle\Sylius\PricingPlugin\Repository
 */
interface CustomDiscountRepositoryInterface extends ObjectRepository
{
    /**
     * @param CustomDiscountableInterface $productVariant
     * @param ChannelInterface $channel
     * @return CustomDiscountInterface[]
     */
    public function getCustomDiscountsPrices(CustomDiscountableInterface $productVariant, ChannelInterface $channel): array;
}
