<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Services;

use LifeStyle\Sylius\PricingPlugin\Entity\CustomDiscountInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\CustomDiscountableInterface;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Interface CustomDiscountFinderInterface
 * @package LifeStyle\Sylius\PricingPlugin\Services
 */
interface CustomDiscountFinderInterface
{
    /**
     * @param CustomDiscountableInterface $customDiscountableEntity
     * @param ChannelInterface $channel
     * @param int $priceListId
     * @return int|null
     */
    public function find(
        CustomDiscountableInterface $customDiscountableEntity,
        ChannelInterface $channel,
        int $priceListId
    ): ?int;

    /**
     * @param CustomDiscountableInterface $customDiscountableEntity
     * @param ChannelInterface $channel
     * @param int $priceListId
     * @return CustomDiscountableInterface[]|null
     */
    public function findAll(
        CustomDiscountableInterface $customDiscountableEntity,
        ChannelInterface $channel,
        int $priceListId
    );
}
