<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

/**
 * Class ResponseDataFactory
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class ResponseDataFactory
{
    /**
     * @return ResponseData
     */
    public function responseData()
    {
        return new ResponseData();
    }

    /**
     * @return CustomDiscountData
     */
    public function customDiscountData()
    {
        return new CustomDiscountData();
    }

    /**
     * @return TierPriceData
     */
    public function tierPriceData()
    {
        return new TierPriceData();
    }

    /**
     * @return ChannelData
     */
    public function channelData()
    {
        return new ChannelData();
    }

    /**
     * @return ShopUserData
     */
    public function shopUserData()
    {
        return new ShopUserData();
    }

    /**
     * @return CalculatedPriceData
     */
    public function calculatedPriceData()
    {
        return new CalculatedPriceData();
    }
}
