<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Form;

use LifeStyle\Sylius\DataModelPlugin\Entity\CustomDiscount;
use LifeStyle\Sylius\DataModelPlugin\Entity\PriceList;
use Sylius\Bundle\ChannelBundle\Form\Type\ChannelChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class CustomDiscountType
 * @package LifeStyle\Sylius\PricingPlugin\Form
 */
class CustomDiscountType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $builder->add('discount', NumberType::class, [
            'label' => 'sylius.ui.discount',
            'required' => true,
        ]);

        $builder->add('priceList', EntityType::class, [
            'class' => PriceList::class,
            'choice_label' => 'name',
            'attr' => ['class' => 'ui dropdown']
        ]);

        $builder->add('channel', ChannelChoiceType::class, [
            'attr' => ['style' => 'display:none'],
        ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setRequired(['currency']);
        $resolver->setDefaults([
            'data_class' => CustomDiscount::class,
            'currency' => 'USD',
        ]);
    }

    /**
     * @return string
     */
    public function getBlockPrefix(): string
    {
        return 'life_style_custom_discount';
    }
}
