<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Repository;

use LifeStyle\Sylius\DataModelPlugin\Entity\TierPriceInterface;
use LifeStyle\Sylius\PricingPlugin\Traits\TierPriceableInterface;
use Doctrine\Common\Persistence\ObjectRepository;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Interface TierPriceRepositoryInterface
 * @package LifeStyle\Sylius\PricingPlugin\Repository
 */
interface TierPriceRepositoryInterface extends ObjectRepository
{
    /**
     * @param TierPriceableInterface $productVariant
     * @param ChannelInterface $channel
     * @return TierPriceInterface[]
     */
    public function getSortedTierPrices(TierPriceableInterface $productVariant, ChannelInterface $channel): array;
}
